class ScheduledMessage {

    /*****************************************************************/
    /*                      Class Constants                          */
    /*****************************************************************/
    
    // Message types
    final static int AVAILABILITY = 1;
    final static int RESPONSIBILITY = 2;
    
    /*****************************************************************/
    /*                     Instance Variables                        */
    /*****************************************************************/

    int type_;
    int point_;
    int exemplar_;
    double priority_;


    /*****************************************************************/
    /*                            Methods                            */
    /*****************************************************************/

    /**
     * Simple default constructor.
     */
    public ScheduledMessage(int type, int point, int exemplar) {
	type_ = type;
	point_ = point;
	exemplar_ = exemplar;
	priority_ = 0;
    }
 
    /**
     * Set priority.  Bigger is more important.
     */   
    public void SetPriority(double priority) {
	priority_ = priority;
    }

    public double Type() {
	return type_;
    }

    public int Point() {
	return point_;
    }
    
    public int Exemplar() {
	return exemplar_;
    }
}
